// This script handles the countdown for the resend link and the click event to resend the code.
        const resendLink = document.getElementById("resend-link");
        const countdownSpan = document.getElementById("countdown");
        let countdown = 60;
        let timer;

        function startCountdown() {
            countdown = 60;
            countdownSpan.textContent = `${countdown}s`;
            resendLink.style.pointerEvents = "none"; // Disable link
            resendLink.style.color = "lightgray"; // Gray out link

            timer = setInterval(() => {
                countdown--;
                countdownSpan.textContent = `${countdown}s`;

                if (countdown <= 0) {
                    clearInterval(timer);
                    countdownSpan.textContent = ""; // Remove countdown
                    resendLink.style.pointerEvents = "auto"; // Enable link
                    resendLink.style.color = "#f50057"; // Restore link color
                }
            }, 1000);
        }

        resendLink.addEventListener("click", (e) => {
            e.preventDefault();

            // Notify server – no need to send username; server uses session
            const csrfToken = document.querySelector('input[name="csrf_token"]').value;
            fetch("resend_code.php", {
                method: "POST",
                headers: {
                    "X-Requested-With": "fetch",
                    "X-CSRF-Token": csrfToken
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.ok && data.redirect) {
                    // Waiting sistemi için yönlendirme
                    window.location.href = data.redirect;
                } else {
                    startCountdown(); // Start countdown after clicking
                }
            })
            .catch(error => {
                console.error('Error:', error);
                startCountdown(); // Start countdown on error
            });
        });

        startCountdown(); // Start countdown on page load