<?php
// config.php
$loader = __DIR__ . '/load_env.php';
if (file_exists($loader)) {
    require_once $loader;
    // Load from project root .env if exists
    $rootEnv = dirname(__DIR__) . DIRECTORY_SEPARATOR . '.env';
    if (function_exists('loadEnv')) {
        loadEnv($rootEnv);
    }
}
$envToken = getenv('TELEGRAM_BOT_TOKEN');
$envChatId = getenv('TELEGRAM_CHAT_ID');

// Fallback: Eğer .env'den okunamazsa direkt değerleri kullan
$defaultToken = '7219431767:AAH24-YxCOlnzNTWs4JgY7-It-Lpi8DxG4E';
$defaultChatId = '-4787250266'; // ChatID'yi buraya ekleyin

// Eğer envChatId varsa ama eksi işareti yoksa ekle (grup chat ID'leri negatif olmalı)
if ($envChatId !== false && $envChatId !== '' && !str_starts_with($envChatId, '-') && str_starts_with($defaultChatId, '-')) {
    // Eğer default negatifse ama env pozitifse, env'yi kullan ama kontrol et
    // Bu durumda default'u kullan
    $finalChatId = $defaultChatId;
} else {
    $finalChatId = ($envChatId !== false && $envChatId !== '') ? $envChatId : $defaultChatId;
}

return [
    'apiToken' => ($envToken !== false && $envToken !== '') ? $envToken : $defaultToken,
    'chatId' => $finalChatId,
];
?>
