<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
function fetchTikTokProfile($username) {

    if (empty($username)) {
        return ['error' => 'Kullanıcı adı boş olamaz.'];
    }
    
    $url = "https://www.tiktok.com/@$username";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $html = curl_exec($ch);
    curl_close($ch);

    if (!$html) {
        return [
            "success" => false,
            "error" => "Sayfa alınamadı!"
        ];
    }

    // __UNIVERSAL_DATA_FOR_REHYDRATION__ scriptini bul
    if (preg_match('/<script[^>]+id="__UNIVERSAL_DATA_FOR_REHYDRATION__"[^>]*>(.*?)<\/script>/is', $html, $matches)) {
        $json = $matches[1];
    } else {
        // Bulamazsa tüm HTML'de JSON'u ara
        if (preg_match('/\{.*"webapp\.user-detail".*?\}\}\}\}\}/s', $html, $matches)) {
            $json = $matches[0];
        } else {
            return [
                "success" => false,
                "error" => "Veri bulunamadı!"
            ];
        }
    }

    $data = json_decode($json, true);

    // user, statsV2 ve shareMeta'yı bul
    $user = [];
    $stats = null;
    $statsV2 = null;
    $shareMeta = null;

    // 1. Doğrudan erişim
    if (isset($data['webapp.user-detail']['userInfo']['user'])) {
        $user = $data['webapp.user-detail']['userInfo']['user'];
        if (isset($data['webapp.user-detail']['userInfo']['statsV2'])) {
            $statsV2 = $data['webapp.user-detail']['userInfo']['statsV2'];
        }
        if (isset($data['webapp.user-detail']['userInfo']['stats'])) {
            $stats = $data['webapp.user-detail']['userInfo']['stats'];
        }
    }

    // 2. statsV2 veya shareMeta bulunamazsa, tüm dizide ara (daha derin arama)
    if (!$statsV2 || !$shareMeta || !$stats) {
        $iterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($data));
        foreach ($iterator as $key => $value) {
            if ($key === 'avatarMedium') $user['avatarMedium'] = $value;
            if ($key === 'signature') $user['signature'] = $value;
            if ($key === 'nickname') $user['nickname'] = $value;
            if ($key === 'verified') $user['verified'] = $value;
            if ($key === 'createTime') $user['createTime'] = $value;
            if ($key === 'secUid') $user['secUid'] = $value;
            if ($key === 'privateAccount') $user['privateAccount'] = $value;
            if ($key === 'region') $user['region'] = $value;
            if ($key === 'statsV2') $statsV2 = $value;
            if ($key === 'stats') $stats = $value;
        }
    }

    // Eğer stats, statsV2 veya shareMeta hala yoksa HTML'den REGEX ile bulmaya çalış
    if (!$stats) {
        if (preg_match('/"stats":(\{.*?\})/s', $html, $m)) {
            $stats = json_decode($m[1], true);
        }
    }
    if (!$statsV2) {
        if (preg_match('/"statsV2":(\{.*?\})/s', $html, $m)) {
            $statsV2 = json_decode($m[1], true);
        }
    }

    // API için toplu JSON veri
    $result = [
        "success" => true,
        "user" => $user,
        "stats" => $stats,
        "statsV2" => $statsV2
    ];

    // Profil resmi base64 kodlama ve diğer verileri formatlama
    $avatarUrl = $user['avatarMedium'] ?? null;
    $profilePicBase64 = 'default_base64'; // fallback değer

    if ($avatarUrl) {
        $avatarData = @file_get_contents($avatarUrl);
        if ($avatarData) {
            $profilePicBase64 = base64_encode($avatarData);
        }
    }

    // Eğer ana veriler yoksa hata döndür (backup kullanma)
    if (empty($user) || empty($stats)) {
        return ['error' => 'Kullanıcı verileri alınamadı!'];
    }

    return [
        'profilePicBase64' => $profilePicBase64,
        'fullName' => $user['nickname'] ?? 'Unknown',
        'followerCount' => formatNumber($stats['followerCount'] ?? 0),
        'followingCount' => formatNumber($stats['followingCount'] ?? 0),
        'mediacount' => formatNumber($stats['heart'] ?? 0),
        'verified' => !empty($user['verified'])
            ? '<img src="assets/img/icons/tiktok-verified-account.svg" alt="Verified">'
            : '',
    ];
}